
  import javafx.application.Application;
  import javafx.geometry.*;
  import javafx.scene.Scene;
  import javafx.scene.control.*;
  import javafx.scene.layout.*;
  import javafx.scene.text.Font;
  import javafx.stage.Stage;
  public class MealMenu extends Application 
  {
     RadioButton hamburger, taco, blt;
     CheckBox cheese, ketchup, napkins;
            
     @Override
     public void start(Stage primaryStage) 
     {
        String blue = "-fx-border-color: rgba(0, 0, 200, 0.7);";

        // Declare the order button and register its event handler
        Button placeOrder = new Button("Place Order");
        placeOrder.setOnAction(e -> placeOrderHandler());
        
        //Build the radio button VBox and group the buttons 
        Label radioLbl = new Label("Entree");
        radioLbl.setFont(new Font("Arial", 16));
        hamburger = new RadioButton("Hamburger");
        taco = new RadioButton("Taco");
        blt = new RadioButton("BLT Sandwich");

        VBox radioPane = new VBox(radioLbl, hamburger, taco, blt);
        radioPane.setPrefWidth(180);
        radioPane.setStyle(blue);
        radioPane.setSpacing(10);
        radioPane.setPadding(new Insets(10));

        ToggleGroup entreeGroup = new ToggleGroup();
        hamburger.setToggleGroup(entreeGroup);
        taco.setToggleGroup(entreeGroup);
        blt.setToggleGroup(entreeGroup);

        //build the check box VBox        
        Label extrasLbl = new Label("Extras");
        extrasLbl.setFont(new Font("Arial", 16));
        cheese = new CheckBox("Cheese");
        ketchup = new CheckBox("Ketchup");
        napkins = new CheckBox("Napkins");
        napkins.setSelected(true);        

        VBox checkPane = new VBox(extrasLbl, cheese, ketchup, napkins);
        checkPane.setPrefWidth(180);
        checkPane.setStyle(blue);
        checkPane.setSpacing(10);
        checkPane.setPadding(new Insets(10));
        
        //Add the VBoxes and the button to a grid pane
        GridPane grid = new GridPane();
        grid.setPadding(new Insets(10));
        grid.setHgap(25);
        grid.setVgap(8);
        grid.addRow(0, radioPane, checkPane);
        grid.add(placeOrder, 0, 1, 2, 1);
        grid.setHalignment(placeOrder, HPos.CENTER);
        
        Scene scene = new Scene(grid, 400, 195);
        
        primaryStage.setTitle("Dollar Meal");
        primaryStage.setScene(scene);
        primaryStage.show();
     }  

     public void placeOrderHandler()
     {
        String order = "";
        if(hamburger.isSelected())
        {
            order = order + "Hamburger";
        }
        else if(taco.isSelected())
        {
            order = order + "Taco";
        }
        else if(blt.isSelected())
        {
            order = order + "BLT sandwich";
        }
        if(cheese.isSelected())
        {
            order = order + ", and cheese";
        }
        if(ketchup.isSelected())
        {
            order = order + ", and ketchup";
        }
        if(napkins.isSelected())
        {
            order = order + ", and napkins";
        }
        System.out.println(order);
     }
    
     public static void main(String[] args) 
     {
        launch(args);
     }
  }
   
